define("widget/mentionable-textarea",["aui","aui/progressive-dataset","backbone","jquery","textarea-caret-position","underscore","xregexp","stash/api/util/navbuilder","util/events","util/function","model/page-state","model/stash-user","widget/autocomplete-dialog"],function(I,M,K,B,J,L,F,C,O,G,H,E,N){function A(){this.init.apply(this,arguments)}A.defaults={$container:B(document.body),selector:"textarea",dialogId:"mention-autocomplete-dialog"};A.prototype.init=function(P){if(this.options){this.reset()}this.options=B.extend({},A.defaults,P);L.bindAll(this,"onKeyDown","onKeyPress","onPaste","onDocumentClick","updateDialogAnchorPosition","updateResults","onActivity","selectItem","highlightMatches");var Q=[];if(H.getPullRequest()){Q=L.map([H.getPullRequest().getAuthor()].concat(H.getPullRequest().getReviewers().models,H.getPullRequest().getParticipants().models),function(R){return R.getUser()})}else{if(H.getCommitParticipants&&H.getCommitParticipants()){Q=H.getCommitParticipants().pluck("user")}}this.dataSource=D(Q,this.matcher);this.dataSource.on("respond",this.updateResults);this.dataSource.on("activity",this.onActivity);this.isMentioningSelector=L.map(this.options.selector.split(","),function(R){return B.trim(R)+".isMentioning"}).join(", ");this.options.$container.on("keypress",this.options.selector,this.onKeyPress);this.options.$container.on("keydown",this.isMentioningSelector,this.onKeyDown);this.options.$container.on("paste",this.isMentioningSelector,this.onPaste)};A.prototype.onKeyDown=function(P){if(!this.dialog){return }switch(P.which){case B.ui.keyCode.ENTER:case B.ui.keyCode.TAB:this.selectHighlightedItem();P.preventDefault();break;case B.ui.keyCode.UP:this.dialog.moveSelectionUp();P.preventDefault();break;case B.ui.keyCode.DOWN:this.dialog.moveSelectionDown();P.preventDefault();break;case B.ui.keyCode.ESCAPE:this.endAutocomplete();P.preventDefault();P.stopPropagation();break;case B.ui.keyCode.BACKSPACE:case B.ui.keyCode.DELETE:this.onKeyPress(P);break}};A.prototype.onKeyPress=function(P){if(P.which){L.defer(L.bind(function(Q){var R=B(Q.target);if(!R.hasClass("isMentioning")){if(String.fromCharCode(Q.which)==="@"){this.beginAutocomplete(R)}}else{this.updateAutocomplete()}},this),P)}};A.prototype.onPaste=function(){L.defer(L.bind(this.updateAutocomplete,this))};A.prototype.onDocumentClick=function(S){var R=S.target;var P=[];this.$textarea&&P.push(this.$textarea);this.dialog&&P.push(this.dialog.$el);var Q=L.any(P,function(T){return T.is(R)||B.contains(T[0],R)});if(!Q){this.endAutocomplete()}};A.prototype.beginAutocomplete=function(Q){var P=Q.getSelection().start-1;if(P>0&&/^\w$/.test(Q.val().substr(P-1,1))){return }this.$textarea=Q;this.$textarea.addClass("isMentioning");this.mentionTriggerPos=P;this.resultsCollection=new K.Collection();this.dialog=new N({id:this.options.dialogId,collection:this.resultsCollection,minZIndex:this.options.$container.zIndex(),anchor:this.getCaretDocumentCoordinates(this.$textarea),template:stash.widget.mentionableTextarea.dialog,highlighter:this.highlightMatches});this.dialog.on("itemSelected",this.selectItem);O.on("window.resize.debounced",this.updateDialogAnchorPosition);B(document).on("click focusin mousedown",this.onDocumentClick);this.updateAutocomplete()};A.prototype.updateAutocomplete=function(){if(!this.$textarea){return }this.currentCaretPos=this.$textarea.getSelection().start;var P=this.$textarea.val().substring(this.mentionTriggerPos,this.currentCaretPos);if(!P||P.indexOf("@")!==0||P.indexOf("\n")!==-1){this.endAutocomplete()}else{P=P.substr(1);this.dataSource.query(P)}};A.prototype.updateDialogAnchorPosition=function(){L.defer(L.bind(function(){if(this.dialog&&this.$textarea){this.dialog.updateAnchorPosition(this.getCaretDocumentCoordinates(this.$textarea))}},this))};A.prototype.updateResults=function(P){if(this.resultsCollection){this.resultsCollection.query=P.query;this.resultsCollection.reset(P.results)}};A.prototype.onActivity=function(P){this.dialog&&this.dialog.toggleSpinner(P.activity)};A.prototype.endAutocomplete=function(){if(this.$textarea){this.$textarea.removeClass("isMentioning");this.$textarea=null}this.mentionTriggerPos=undefined;this.currentCaretPos=undefined;if(this.dialog){this.dialog.off("itemSelected",this.selectItem);this.dialog.remove();this.dialog=null}this.resultsCollection=null;O.off("window.resize.debounced",this.updateDialogAnchorPosition);B(document).off("click focusin mousedown",this.onDocumentClick)};A.prototype.selectHighlightedItem=function(){this.selectItem(this.dialog.getSelectedItemIndex())};A.prototype.selectItem=function(R){var Q=this.resultsCollection.at(R);if(Q){var P=this.escapeUsername(Q.getName()),V=this.$textarea.val(),U=V.substring(0,this.mentionTriggerPos+1),T=V.substring(this.currentCaretPos,V.length),S=U.length+P.length+1;if(T.charAt(0)!==" "){T=" "+T}this.$textarea.val(U+P+T);this.$textarea.setSelection(S,S)}this.endAutocomplete()};A.prototype.matcher=function(Q,R){if(H.getCurrentUser()&&Q.getName()===H.getCurrentUser().getName()){return false}var P=F.cache("(\\b|^|[^\\p{L}\\p{N}])"+F.escape(R),"i"),S=[Q.getName(),Q.getEmailAddress(),Q.getDisplayName()];return L.any(S,function(T){return !!(T&&P.test(T))})};A.prototype.getMatchParts=function(S,R){var Q=F.cache("(^|.*?(\\b|\\())("+F.escape(R)+")(.*)","i"),P={text:S};if(S.toLowerCase().indexOf(R.toLowerCase())>-1){S.replace(Q,function(U,W,V,T,X){P={prefix:W,match:T,suffix:X}})}return P};A.prototype.highlightMatches=function(P,R){var Q=this;P.find(".avatar-with-name, .email-address").each(function(){var S=B(this).contents().filter(function(){return this.nodeType===Node.TEXT_NODE}),T=L.reduce(Q.getMatchParts(S.text(),R),function(U,V,W){return U+((W==="match")?"<b>"+I.escapeHtml(V)+"</b>":I.escapeHtml(V))},"");S.replaceWith(T)});return P};A.prototype.getCaretDocumentCoordinates=function(S){var P=S.offset();var R=J(S[0],S[0].selectionStart);var Q=parseInt(S.css("font-size"),10);R.top+=(P.top+Q);R.left+=P.left;return R};A.prototype.escapeUsername=function(P){if(/^\w*$/.test(P)){return P}else{return'"'+P.replace(/"/g,'\\"')+'"'}};A.prototype.reset=function(){this.destroy();delete this.options;delete this.dataSource;delete this.$textarea;delete this.dialog;delete this.resultsCollection;delete this.mentionTriggerPos;delete this.currentCaretPos};A.prototype.destroy=function(){if(this.dialog){this.dialog.off("itemSelected",this.selectItem);this.dialog.remove()}this.dataSource.off("respond",this.updateResults);this.dataSource.off("activity",this.onActivity);this.options.$container.off("keypress",this.options.selector,this.onKeyPress);this.options.$container.off("keydown",this.isMentioningSelector,this.onKeyDown);this.options.$container.off("paste",this.isMentioningSelector,this.onPaste);O.off("window.resize.debounced",this.updateDialogAnchorPosition);B(document).off("click focusin mousedown",this.onDocumentClick)};var D=L.once(function(Q,P){var R=new M(Q,{queryEndpoint:C.rest().users().build(),queryParamKey:"filter",queryData:{avatarSize:stash.widget.avatarSizeInPx({size:"small"})},maxResults:5,model:E,matcher:P});R.parse=G.dot("values");R.getFilteredResults=function(T){var S=this.filter(function(U){return(!!this.matcher(U,T))},this);if(this._maxResults){S=L.first(S,this._maxResults)}return S};return R});return A});