define("widget/image-explorer",["jquery","underscore"],function(B,A){function C(E,D){this.init.apply(this,arguments)}C.scaleModes={fill:"fill",contain:"contain",containAndFill:"containAndFill"};C.zoomModes={localZoom:"localZoom",imageZoom:"imageZoom"};C.maskShapes={CIRCLE:"circle",SQUARE:"square",ROUNDED_SQUARE:"rounded-square"};C.prototype.defaults={initialScaleMode:C.scaleModes.containAndFill,zoomMode:C.zoomModes.localZoom,emptyClass:"empty",scaleMax:1};C.prototype.init=function(E,D){this.$container=E;this.$imageView=this.$container.find(".image-explorer-image-view");this.$sourceImage=this.$container.find(".image-explorer-source");this.$mask=this.$container.find(".image-explorer-mask");this.$dragDelegate=this.$container.find(".image-explorer-drag-delegate");this.$scaleSlider=this.$container.find(".image-explorer-scale-slider");this.options=B.extend({},this.defaults,D);this.imageProperties={};A.bindAll(this,"getImageSrc","setImageSrc","initImage","initDragDelegate","initScaleSlider","setInitialScale","getFillScale","getContainedScale","getCircularContainedScale","sliderValToScale","scaleToSliderVal","updateImageScale","resetImagePosition","resetScaleSlider","toggleEmpty","get$ImageView","get$SourceImage","get$Mask","get$DragDelegate","getMaskedImageProperties","showError","clearError","hasValidImage","_resetFromError","_removeError");this.toggleEmpty(true);if(this.$sourceImage[0].naturalWidth){this.toggleEmpty(false);this.initImage({target:this.$sourceImage[0]})}this.$sourceImage.on("load",this.initImage);this.initDragDelegate();this.initScaleSlider()};C.prototype.getImageSrc=function(){return(this.$sourceImage)?this.$sourceImage.attr("src"):undefined};C.prototype.setImageSrc=function(D){if(this.$sourceImage){this.$sourceImage.attr("src","");if(D){this.$sourceImage.attr("src",D)}else{this.toggleEmpty(true)}}};C.prototype.initImage=function(E){var D=E.target;this.imageProperties.naturalWidth=D.naturalWidth;this.imageProperties.naturalHeight=D.naturalHeight;this._removeError();this.toggleEmpty(false);this.setInitialScale()};C.prototype.initDragDelegate=function(){var D;this.$dragDelegate.draggable({start:A.bind(function(){D=this.$sourceImage.offset()},this),drag:A.bind(function(F,E){this.$sourceImage.offset({top:D.top+E.position.top-E.originalPosition.top,left:D.left+E.position.left-E.originalPosition.left})},this),revert:true,revertDuration:0})};C.prototype.initScaleSlider=function(){this.$scaleSlider.on("change input",A.bind(function(D){this.updateImageScale(this.sliderValToScale(D.target.value))},this))};C.prototype.setInitialScale=function(){var H=this.$mask.width(),F=this.$mask.height(),E=this.imageProperties.naturalWidth,G=this.imageProperties.naturalHeight,D=1;this.minScale=1;switch(this.options.initialScaleMode){case C.scaleModes.fill:this.minScale=D=this.getFillScale(E,G,H,F);break;case C.scaleModes.contain:if(this.$mask.hasClass("circle-mask")){this.minScale=D=this.getCircularContainedScale(E,G,H/2)}else{this.minScale=D=this.getContainedScale(E,G,H,F)}break;case C.scaleModes.containAndFill:if(this.$mask.hasClass("circle-mask")){this.minScale=this.getCircularContainedScale(E,G,H/2)}else{this.minScale=this.getContainedScale(E,G,H,F)}D=this.getFillScale(E,G,H,F);break}this.maxScale=Math.max(D,this.options.scaleMax);this.resetScaleSlider(this.scaleToSliderVal(D));this.updateImageScale(D,C.zoomModes.imageZoom);this.resetImagePosition()};C.prototype.getFillScale=function(F,D,E,I){var H=E/F,G=I/D;return Math.max(H,G)};C.prototype.getContainedScale=function(F,D,E,I){var H=E/F,G=I/D;return Math.min(H,G)};C.prototype.getCircularContainedScale=function(E,D,H){var G=Math.atan(D/E),F=Math.cos(G)*H*2;return F/E};C.prototype.sliderValToScale=function(E){var D=E/(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"));return this.minScale+(D*(this.maxScale-this.minScale))};C.prototype.scaleToSliderVal=function(E){var D=(E-this.minScale)/(this.maxScale-this.minScale);return D*(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"))};C.prototype.updateImageScale=function(J,L){var I=Math.round(J*this.imageProperties.naturalWidth),D=Math.round(J*this.imageProperties.naturalHeight),F,E;L=L||this.options.zoomMode;switch(L){case C.zoomModes.imageZoom:F=-1*I/2;E=-1*D/2;break;case C.zoomModes.localZoom:var H=this.$sourceImage.width(),R=this.$sourceImage.height(),N=parseInt(this.$sourceImage.css("margin-left"),10),G=parseInt(this.$sourceImage.css("margin-top"),10),Q=this.$sourceImage.position(),P=this.$imageView.width()/2,O=this.$imageView.height()/2,M=P-Q.left-N,K=O-Q.top-G,T=(M/H)*I,S=(K/R)*D;F=P-Q.left-T;E=O-Q.top-S;break}this.$sourceImage.width(I).height(D).css({"margin-left":Math.round(F)+"px","margin-top":Math.round(E)+"px"})};C.prototype.resetImagePosition=function(){this.$sourceImage.css({top:"50%",left:"50%"})};C.prototype.resetScaleSlider=function(D){this.$scaleSlider.val(D).removeClass("disabled").removeAttr("disabled");fdSlider.updateSlider(this.$scaleSlider.attr("id"))};C.prototype.toggleEmpty=function(D){this.$container.toggleClass(this.options.emptyClass,D)};C.prototype.get$ImageView=function(){return this.$imageView};C.prototype.get$SourceImage=function(){return this.$sourceImage};C.prototype.get$Mask=function(){return this.$mask};C.prototype.get$DragDelegate=function(){return this.$dragDelegate};C.prototype.getMaskedImageProperties=function(){var F=this.$sourceImage.width()/this.imageProperties.naturalWidth,E=this.$sourceImage.height()/this.imageProperties.naturalHeight,D=this.$mask.position(),G=this.$sourceImage.position();D.top+=parseInt(this.$mask.css("margin-top"),10);D.left+=parseInt(this.$mask.css("margin-left"),10);G.top+=parseInt(this.$sourceImage.css("margin-top"),10);G.left+=parseInt(this.$sourceImage.css("margin-left"),10);return{maskedAreaImageX:Math.round((D.left-G.left)/F),maskedAreaImageY:Math.round((D.top-G.top)/E),maskedAreaWidth:Math.round(this.$mask.width()/F),maskedAreaHeight:Math.round(this.$mask.height()/E)}};C.prototype.showError=function(F,E){this._removeError();this.toggleEmpty(true);this.$container.addClass("error");var D=B(aui.message.error({titleContent:AJS.escapeHtml(F),content:E||"",isCloseable:true}));D.appendTo(this.$imageView).css({"margin-top":-1*D.outerHeight()/2});D.on("messageClose",this._resetFromError);AJS.messages.setup()};C.prototype.clearError=function(){this._removeError();this._resetFromError()};C.prototype.hasValidImage=function(){return !!(this.getImageSrc()&&this.$sourceImage.prop("naturalWidth"))};C.prototype._resetFromError=function(){var D=this.hasValidImage();this.toggleEmpty(!D);this.$container.removeClass("error");A.isFunction(this.options.onErrorReset)&&this.options.onErrorReset(D?this.getImageSrc():undefined)};C.prototype._removeError=function(){this.$imageView.find(".aui-message-error").remove()};return C});