define('page/users/account', [
    'jquery',
    'widget/user-avatar-form',
    'exports'
], function (
    $,
    UserAvatarForm,
    exports
) {
    'use strict';

    function cleanErrors() {
        $('.user-avatar-error').remove();
    }

    function notifyError(message) {
        cleanErrors();
        $('.aui-page-panel-content > .aui-page-header').after(
            aui.message.error({
                content: message,
                extraClasses: 'user-avatar-error'
            })
        );
    }

    exports.onReady = function(user, avatarContainerSelector) {
        var avatarForm = new UserAvatarForm($(avatarContainerSelector), user);
        avatarForm.on('avatarChanged', cleanErrors);
        avatarForm.on('avatarUploadError', notifyError);
        avatarForm.on('avatarDeleteError', notifyError);
    };

});
