define('page/pull-request/pull-request-view', [
    'jquery',
    'model/page-state',
    'widget/unwatch-notification',
    'layout/pull-request',
    'exports'
], function (
    $,
    pageState,
    unwatchNotification,
    pullRequestLayout,
    exports
) {

    exports.registerHandler = pullRequestLayout.registerHandler;

    exports.onReady = function(unwatched) {
        if (unwatched) {
            var unwatchOptions = {
                dialogTitle: AJS.I18n.getText('stash.web.pullrequest.unwatched.header',
                    pageState.getPullRequest().getId()),
                dialogText: AJS.I18n.getText('stash.web.pullrequest.unwatched.content')
            };

            $(window).load(unwatchNotification.bind(null, unwatchOptions));
        }
    };
});
