define('page/maintenance/migration', [
    'stash/api/util/navbuilder',
    'layout/maintenance',
    'exports'
], function(
    navBuilder,
    maintenance,
    exports
) {
        exports.onReady = function(hasToken) {

            var opts = {
                redirectUrl: hasToken ? navBuilder.admin().db().build() : navBuilder.allProjects().build(),
                canceledHeader: AJS.I18n.getText('stash.web.migration.canceled.title'),
                cancelingDescription: AJS.I18n.getText('stash.web.migration.canceling.description'),
                cancelDialogTitle: AJS.I18n.getText('stash.web.migration.dialog.title'),
                cancelDialogDescription: AJS.I18n.getText('stash.web.migration.dialog.description'),
                cancelDialogButtonText: AJS.I18n.getText('stash.web.migration.dialog.cancel')
            };

            maintenance.init(opts);
        };
});
