define('feature/pull-request/metadata-generator', [
    'jquery',
    'util/function',
    'util/text',
    'model/revision-reference',
    'exports'
], function (
    $,
    fn,
    textUtil,
    RevisionRef,
    exports
) {

    var handlesNewlinesInTextCorrectly = ($('<div>').text('\n').text().length === 1);

    function generateTitleFromBranchName(branchNameOrRevisionRef){
        return textUtil.convertBranchNameToSentence((branchNameOrRevisionRef instanceof RevisionRef) ? branchNameOrRevisionRef.getDisplayId() : branchNameOrRevisionRef);
    }

    function generateDescriptionFromCommitTableRows(tableRows) {
        return generateDescription($(tableRows).filter(':not(.merge)'), getCommitMessageFromTableRow);
    }

    function getCommitMessageFromTableRow(tableRow) {
        return $(tableRow).find('.message span').text();
    }

    function generateDescriptionFromCommitJson(commits) {
        return generateDescription(commits.values, fn.dot('message'));
    }

    function generateDescription(commitList, messageExtractor) {
        if (!handlesNewlinesInTextCorrectly) {
            return;
        }

        var description = '';

        // If there's multiple commits put in a list
        if (commitList.length > 1) {
            messageExtractor = _.compose(convertMessageToListItem, messageExtractor);
        }

        if (commitList.length  > 0) {
            description = _.map(commitList, messageExtractor)
                .reverse()              //oldest commits first.
                .join('')
                .trim();
        }
        return description;
    }

    function convertMessageToListItem(message) {
        // Compress lines where more than one line is empty into one empty line. Otherwise it would be parsed as the
        // end of the list and the following lines would behave differently (e.g. get turned into code blocks).
        var newlinesReplaced = message.replace(/\n\n+/g, '\n\n');

        // Indent contents so they are nested under the commit list.
        var indentRegex = /\n(.)/g,
            indentReplacement = '\n' + textUtil.indent('$1');

        var indented = newlinesReplaced.replace(indentRegex, indentReplacement);

        // For multi-paragraph messages, add empty line so that there's more space between this and next bullet
        var trailer = indented.indexOf('\n\n') !== -1 ? '\n\n' : '\n';
        return '* ' + indented + trailer;
    }

    exports.generateTitleFromBranchName = generateTitleFromBranchName;
    exports.generateDescriptionFromCommitsJson = generateDescriptionFromCommitJson;
    exports.generateDescriptionFromCommitsTableRows = generateDescriptionFromCommitTableRows;
});