define('feature/pull-request/pull-request-commits', [
    'jquery',
    'stash/api/util/navbuilder',
    'feature/commits/commits-table',
    'exports'
], function(
    $,
    navBuilder,
    CommitsTable,
    exports
) {
        var pullRequestId,
            commitsTable;

        function getCommitsUrlBuilder() {
            var builder = navBuilder
                .currentRepo()
                .pullRequest(pullRequestId)
                .commits();

            return builder;
        }

        exports.init = function(options){

            pullRequestId = options.pullRequest.getId();

            var $table = $(stash.feature.pullRequest.commits({
                repository : options.repository.toJSON(),
                commitsTableWebSections : options.commitsTableWebSections
            }));

            // HACK: We keep the table out of the DOM until it's fully initialized (for UX reasons).
            // HACK: To avoid multiple pages being loaded because of this, we suspend the commits table, and
            // HACK: resume once the table is in the DOM.
            // HACK: $fakeParent is required because paged-table adds a spinner as a sibling.
            var $fakeParent = $('<div />').append($table);

            commitsTable = new CommitsTable(getCommitsUrlBuilder, {
                target: $table,
                webSections : options.commitsTableWebSections,
                allCommitsFetchedMessage: AJS.I18n.getText('stash.web.pullrequest.allcommitsfetched')
            });

            // HACK: see note on $fakeParent above.
            $(options.el).append(commitsTable.$spinner);

            // HACK: see note on $fakeParent above.
            var promise = commitsTable.init({ suspended : true }).done(function() {
                $(options.el).prepend($fakeParent.children());
                commitsTable.resume();
            });

            commitsTable.bindKeyboardShortcuts();

            return promise;
        };

        exports.reset = function() {
            commitsTable.destroy();
            commitsTable = null;
        };
    });