(function() {

    // These _have_ to be registered once/globally :(
    var requestIgnoreWhitespace = require('util/bacon').keyboardEvents('requestIgnoreWhitespace');
    var requestHideComments = require('util/bacon').keyboardEvents('requestHideComments');
    var requestHideEdiff = require('util/bacon').keyboardEvents('requestHideEdiff');
    var changeDiffTypeRequested = require('util/bacon').keyboardEvents('changeDiffTypeRequested');

define('feature/file-content/diff-view-options-panel', [
    'chaperone',
    'jquery',
    'underscore',
    'util/events',
    'util/function'
], function (
    Chaperone,
    $,
    _,
    events,
    fn
    ){

    var ddTrigger = '#diff-options-dropdown-trigger';

    Chaperone.registerFeature('side-by-side-diff-discovery', [{
        id : 'side-by-side-diff-discovery',
        selector : ddTrigger,
        title : AJS.I18n.getText('stash.web.diff.sidebyside.feature.discovery.title'),
        content : AJS.escapeHtml(AJS.I18n.getText('stash.web.diff.sidebyside.feature.discovery.content')),
        once: true
    }]);

    return function($document, diffViewOptions) {

        var ddList = '#diff-options-dropdown';
        var ddCoreItems = '#diff-options-core a';
        var destroyables = [];

        // Update the diffOptions when an item is checked/unchecked
        function itemCheckStateChanged(e) {
            closeDiffViewOptions();
            var $el = $(this);
            var key = $el.attr('data-key');
            var val = $el.attr('data-value');
            var checked = (e.type === 'aui-dropdown2-item-check');

            if ($el.is('[role=radio]') && !checked) {
                return;
            }

            diffViewOptions.set(key, val || checked);
        }


        // Check/Uncheck options visually when the dropdown is shown.
        function optionsDropdownShown(e) {
            // If an item has a matching diff option set it to the value.
            // default to false
            $(this).find('#diff-options-core a').each(function() {
                var $el = $(this);
                var key = $el.attr('data-key');
                var val = $el.attr('data-value');
                var storedValue = diffViewOptions.get(key);
                var isChecked = (storedValue && (storedValue === val || storedValue === true));

                $el.toggleClass('checked', isChecked);
            });

            destroyables.push(events.chain().on('window.scroll.throttled', closeDiffViewOptions).destroy);
        }

        function optionsDropdownHidden(e) {
            events.off('window.scroll.throttled', closeDiffViewOptions);
        }

        /**
         * Close the Diff View Options dropdown
         *
         * When the page is scrolled or when the options have changed, we want to
         * close the menu to avoid having it open when the user gets back to the page.
         *
         * In this particular scenario, the toolbar that contains the dropdown
         * can become position:fixed. This detaches the dropdown from the button location
         * and causes it to float on the page by itself until the toolbar is no longer fixed.
         *
         * @param {Event} e
         */
        function closeDiffViewOptions(e) {
            if ($document.find(ddList).attr('aria-hidden') === 'false') {
                $document.find(ddTrigger).trigger('aui-button-invoke');
            }
        }

        /**
         * Toggle a diff view option.
         *
         * @param {string} optionKey
         */
        function toggleDiffViewOption(optionKey) {
            closeDiffViewOptions();
            diffViewOptions.set(optionKey, !diffViewOptions.get(optionKey));

        }

        /**
         * Toggle the side-by-side-diff view. This would be triggered from a keyboard shortcut
         */
        function changeDiffType() {
            closeDiffViewOptions();
            diffViewOptions.set('diffType', diffViewOptions.get('diffType') === 'unified' ? 'side-by-side' : 'unified');
        }

        destroyables.push(requestIgnoreWhitespace.onValue(toggleDiffViewOption.bind(null, 'ignoreWhitespace')));
        destroyables.push(requestHideComments.onValue(toggleDiffViewOption.bind(null, 'hideComments')));
        destroyables.push(requestHideEdiff.onValue(toggleDiffViewOption.bind(null, 'hideEdiff')));
        destroyables.push(changeDiffTypeRequested.onValue(changeDiffType));
        destroyables.push(events.chainWith($document)
            .on('aui-dropdown2-item-check aui-dropdown2-item-uncheck', ddCoreItems, itemCheckStateChanged)
            .on('aui-dropdown2-show', ddList, optionsDropdownShown)
            .on('aui-dropdown2-hide', ddList, optionsDropdownHidden)
            .destroy
        );

        return {
            destroy: _.partial(fn.applyAll, destroyables)
        };
    };
});
})();