define('feature/changeset/difftree/difftree-search-input', [
    'jquery',
    'underscore',
    'util/events',
    'util/function'
], function(
    $,
    _,
    events,
    fn
) {

    "use strict";

    function SearchInput(opts) {
        this.$el = $(stash.feature.difftree.searchInput(opts));

        this._destroyables = [];

        var $input = this.$el.find('input');
        var $deleteButton = this.$el.find('.delete-button');
        this._destroyables.push(events.chainWith($deleteButton).on('click', function() {
            $input.val('').trigger('input');
        }));
        this._destroyables.push(events.chainWith($input).on('input', function(e) {
            $deleteButton.toggle(!!this.value);
        }));
    }

    /**
     * @returns {Bacon<string>} a stream of text inputs, where blank indicates the user wants to clear the search
     */
    SearchInput.prototype.getInputs = function () {
        var clearEvents = this.$el.find('.delete-button').asEventStream('click');
        var keyup = this.$el.asEventStream('keyup');
        var escape = keyup
            .filter(_.compose(fn.eq($.ui.keyCode.ESCAPE), fn.dot('keyCode')))
            // Clear the results when the user presses escape
            .doAction(function (e) {
                $(e.target).val('').trigger('input');
            });
        return keyup
            .filter(_.compose(fn.eq($.ui.keyCode.ENTER), fn.dot('keyCode')))
            .merge(escape)
            .doAction(fn.invoke('preventDefault'))
            .flatMap(function (e) {
                return $(e.target).val();
            })
            .merge(clearEvents.map(fn.constant('')))
            .skipDuplicates();
    };

    SearchInput.prototype.destroy = function() {
        _.invoke(this._destroyables, 'destroy');
    };

    return SearchInput;
});
