# Stash i18n Properties Naming Convention

## Conventions

* General structure, where each module corresponds to its Maven project, and sections are semantically grouped together.

	`stash.[module].[section].{more sections if required}.[key]`

* Keys should be all in lowercase; non-alphanumeric, non-period characters are discouraged. Properties are handled as ISO 8859-1 encoded by default; non-conformant characters are forbidden. (If you need to insert a Unicode character into a properties file as a value, use \u0000 notation, though Unicode characters must not be used in property keys.)	

	`stash.web.about.copyright=Copyright \u00A9 {0} Atlassian Corporation Pty Ltd.`

* Singular tags are preferred over plural. (Exceptions: situations where the intent is clearer with the plural, e.g. settings)

	`stash.web.admin.commit.*`
	
	instead of

	`stash.web.admin.commits.*`

* Tags and semantic groups with multiple words should generally be concatenated without separating characters or camel casing.

	`stash.web.admin.pullrequest.*`

	instead of

	`stash.web.admin.pullRequest.*, stash.web.admin.pull-request.*, stash.web.admin.pull.request.*`

* Common keys should be specified in a "global" group at the level of re-use.

	A key commonly used across the web module:

	`stash.web.global.cancel`

	A key commonly used across the entire Stash project:

	`stash.global.appname`

* Verbs should typically go at the end of a key. (Exception: if there are no other similar keys and it makes sense to concatenate, do so; e.g. `stash.web.pullrequest.createemail` if there were no other keys in `stash.web.pullrequest.email.*`.)

	`stash.web.pullrequest.email.create`

	instead of

	`stash.web.pullrequest.create.email`

* If there are multiple related keys that justify creating a new group, create that group.
	
	Refactor:

	`stash.web.pullrequest.createemail, stash.web.pullrequest.sendemail`

	into:

	`stash.web.pullrequest.email.create, stash.web.pullrequest.email.send`

* Key sections should progress from broader scope to narrower scope.

	`stash.web.settings.admin.database.hostname`

	instead of

	`stash.web.admin.database.settings.hostname`
