/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.AbstractEvictableRecordStore;
import com.hazelcast.map.AbstractRecordStore;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.NearCacheProvider;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.eviction.EvictionHelper;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

abstract class AbstractEvictableRecordStore
extends AbstractRecordStore {
    protected static final int POST_READ_CHECK_POINT = 63;
    protected volatile boolean expirable;
    protected Iterator<Record> expirationIterator;
    protected int readCountBeforeCleanUp;
    protected long lruAccessSequenceNumber;
    protected boolean evictionEnabled;
    protected long lastEvictionTime;

    protected AbstractEvictableRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        this.evictionEnabled = !MapConfig.EvictionPolicy.NONE.equals((Object)mapContainer.getMapConfig().getEvictionPolicy());
        this.expirable = this.isRecordStoreExpirable();
    }

    private boolean isRecordStoreExpirable() {
        return this.mapContainer.getMapConfig().getMaxIdleSeconds() > 0 || this.mapContainer.getMapConfig().getTimeToLiveSeconds() > 0;
    }

    public void evictExpiredEntries(int percentage, boolean ownerPartition) {
        long now = this.getNow();
        int size = this.size();
        int maxIterationCount = this.getMaxIterationCount(size, percentage);
        int maxRetry = 3;
        int loop = 0;
        int evictedEntryCount = 0;
        while ((evictedEntryCount += this.evictExpiredEntries0(maxIterationCount, now, ownerPartition)) < maxIterationCount && ++loop <= 3) {
        }
    }

    public boolean isExpirable() {
        return this.expirable;
    }

    private int getMaxIterationCount(int size, int percentage) {
        int defaultMaxIterationCount = 100;
        float oneHundred = 100.0f;
        float maxIterationCount = (float)size * ((float)percentage / 100.0f);
        if (maxIterationCount <= 100.0f) {
            return 100;
        }
        return Math.round(maxIterationCount);
    }

    private int evictExpiredEntries0(int maxIterationCount, long now, boolean ownerPartition) {
        int evictedCount = 0;
        int checkedEntryCount = 0;
        this.initExpirationIterator();
        while (this.expirationIterator.hasNext() && checkedEntryCount < maxIterationCount) {
            ++checkedEntryCount;
            Record record = (Record)this.expirationIterator.next();
            Data key = record.getKey();
            if (this.isLocked(key) || this.isReachable(record, now)) continue;
            Object value = record.getValue();
            this.evict0(key);
            ++evictedCount;
            this.initExpirationIterator();
            if (ownerPartition) {
                this.doPostEvictionOperations(key, value);
            }
            if (this.expirationIterator.hasNext()) continue;
            break;
        }
        return evictedCount;
    }

    private void initExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = this.records.values().iterator();
        }
    }

    protected void resetAccessSequenceNumber() {
        this.lruAccessSequenceNumber = 0L;
    }

    protected void earlyWriteCleanup(long now) {
        if (this.evictionEnabled) {
            this.cleanUp(now);
        }
    }

    protected void postReadCleanUp(long now) {
        if (this.evictionEnabled) {
            ++this.readCountBeforeCleanUp;
            if ((this.readCountBeforeCleanUp & 0x3F) == 0) {
                this.cleanUp(now);
            }
        }
    }

    private void cleanUp(long now) {
        if (this.size() == 0) {
            return;
        }
        if (this.isEvictable()) {
            this.removeEvictables();
            this.lastEvictionTime = now;
            this.readCountBeforeCleanUp = 0;
        }
    }

    private void removeEvictables() {
        int evictableSize = this.getEvictableSize();
        if (evictableSize < 1) {
            return;
        }
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        EvictionHelper.removeEvictableRecords((RecordStore)this, (int)evictableSize, (MapConfig)mapConfig, (MapServiceContext)this.mapServiceContext);
    }

    private int getEvictableSize() {
        int size = this.size();
        if (size < 1) {
            return 0;
        }
        int evictableSize = EvictionHelper.getEvictableSize((int)size, (MapConfig)this.mapContainer.getMapConfig(), (MapServiceContext)this.mapServiceContext);
        if (evictableSize < 1) {
            return 0;
        }
        return evictableSize;
    }

    private boolean isEvictable() {
        return EvictionHelper.checkEvictable((MapContainer)this.mapContainer);
    }

    protected Record nullIfExpired(Record record) {
        return this.evictIfNotReachable(record);
    }

    protected void markRecordStoreExpirable(long ttl) {
        if (ttl > 0L) {
            this.expirable = true;
        }
    }

    abstract Object evict0(Data var1);

    private Record evictIfNotReachable(Record record) {
        if (record == null) {
            return null;
        }
        if (this.isLocked(record.getKey())) {
            return record;
        }
        if (this.isReachable(record)) {
            return record;
        }
        Data key = record.getKey();
        Object value = record.getValue();
        this.evict(key);
        this.doPostEvictionOperations(key, value);
        return null;
    }

    private boolean isReachable(Record record) {
        long now = this.getNow();
        return this.isReachable(record, now);
    }

    private boolean isReachable(Record record, long time) {
        Record idleExpired = this.isIdleExpired(record, time);
        if (idleExpired == null) {
            return false;
        }
        Record ttlExpired = this.isTTLExpired(record, time);
        return ttlExpired != null;
    }

    private Record isIdleExpired(Record record, long time) {
        if (record == null) {
            return null;
        }
        long lastAccessTime = record.getLastAccessTime();
        assert (lastAccessTime > 0L);
        assert (time > 0L);
        assert (time >= lastAccessTime);
        long idleTime = this.getIdleTime();
        boolean result = time - lastAccessTime >= idleTime;
        return result ? null : record;
    }

    private long getIdleTime() {
        int maxIdleSeconds = this.mapContainer.getMapConfig().getMaxIdleSeconds();
        return maxIdleSeconds == 0 ? Long.MAX_VALUE : this.mapServiceContext.convertTime((long)maxIdleSeconds, TimeUnit.SECONDS);
    }

    private Record isTTLExpired(Record record, long time) {
        if (record == null) {
            return null;
        }
        long ttl = record.getTtl();
        if (ttl < 1L) {
            return record;
        }
        long creationTime = record.getCreationTime();
        assert (ttl > 0L) : String.format("wrong ttl %d", ttl);
        assert (creationTime > 0L) : String.format("wrong creationTime %d", creationTime);
        assert (time > 0L) : String.format("wrong time %d", time);
        assert (time >= creationTime) : String.format("time >= lastUpdateTime (%d >= %d)", time, creationTime);
        boolean result = time - creationTime >= ttl;
        return result ? null : record;
    }

    private void doPostEvictionOperations(Data key, Object value) {
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        if (nearCacheProvider.isNearCacheAndInvalidationEnabled(this.name)) {
            nearCacheProvider.invalidateAllNearCaches(this.name, key);
        }
        EvictionHelper.fireEvent((Data)key, (Object)value, (String)this.name, (MapServiceContext)this.mapServiceContext);
    }

    protected void increaseRecordEvictionCriteriaNumber(Record record, MapConfig.EvictionPolicy evictionPolicy) {
        switch (1.$SwitchMap$com$hazelcast$config$MapConfig$EvictionPolicy[evictionPolicy.ordinal()]) {
            case 1: {
                ++this.lruAccessSequenceNumber;
                record.setEvictionCriteriaNumber(this.lruAccessSequenceNumber);
                break;
            }
            case 2: {
                record.setEvictionCriteriaNumber(record.getEvictionCriteriaNumber() + 1L);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate eviction policy [" + evictionPolicy + ']');
            }
        }
    }

    protected void accessRecord(Record record, long now) {
        super.accessRecord(record, now);
        this.increaseRecordEvictionCriteriaNumber(record, this.mapContainer.getMapConfig().getEvictionPolicy());
    }
}

