/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.xsrf;

import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.util.xsrf.XsrfTokenGenerator;
import com.atlassian.stash.nav.NavBuilder;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

/*
 * Exception performing whole class analysis ignored.
 */
public class XsrfTokenInterceptor
extends HandlerInterceptorAdapter {
    public static final String XSRF_TOKEN_NAME = "xsrfTokenName";
    public static final String XSRF_TOKEN_VALUE = "xsrfTokenValue";
    public static final String XSRF_FORWARD = "xsrf-forward";
    public static final String XSRF_ORIGINAL_URL = "xsrf-original-url";
    private final NavBuilder navBuilder;
    private final XsrfTokenGenerator xsrfTokenGenerator;

    @Autowired
    public XsrfTokenInterceptor(XsrfTokenGenerator xsrfTokenGenerator, NavBuilder navBuilder) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.navBuilder = navBuilder;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if ("POST".equals(request.getMethod()) && !XsrfTokenInterceptor.isForwarded((HttpServletRequest)request) && !this.xsrfTokenGenerator.hasValidToken(request)) {
            Method method;
            if (handler instanceof HandlerMethod && (method = ((HandlerMethod)handler).getMethod()) != null && method.getAnnotation(IgnoresXsrf.class) != null) {
                return true;
            }
            request.setAttribute("xsrf-original-url", (Object)request.getRequestURI());
            request.setAttribute("xsrf-forward", (Object)true);
            request.getRequestDispatcher(this.xsrfUrl()).forward((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (!response.isCommitted()) {
            request.setAttribute("xsrfTokenName", (Object)this.xsrfTokenGenerator.getXsrfTokenName());
            request.setAttribute("xsrfTokenValue", (Object)this.xsrfTokenGenerator.generateToken(request));
        }
    }

    protected String xsrfUrl() {
        return this.navBuilder.xsrfNotification().buildRelNoContext();
    }

    public static boolean isForwarded(HttpServletRequest request) {
        return request.getAttribute("xsrf-forward") != null;
    }
}

