/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.setup;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.ApplicationSetupEvent;
import com.atlassian.stash.internal.web.util.xsrf.XsrfTokenInterceptor;
import com.atlassian.stash.server.ApplicationPropertiesService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public final class SetupRedirectInterceptor
extends HandlerInterceptorAdapter {
    private static final String SETUP_PATH = "/setup";
    static final String SETUP_ATTRIBUTE = "preHandledBy-" + SetupRedirectInterceptor.class.getSimpleName();
    private final ApplicationPropertiesService propertiesService;
    private volatile boolean applicationSetup;

    public SetupRedirectInterceptor(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
        this.applicationSetup = propertiesService.isSetup();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.applicationSetup) {
            return true;
        }
        this.applicationSetup = this.propertiesService.isSetup();
        if (this.applicationSetup) {
            return true;
        }
        if (this.shouldRedirect(request)) {
            response.sendRedirect(request.getContextPath() + SETUP_PATH);
            return false;
        }
        request.setAttribute(SETUP_ATTRIBUTE, (Object)Boolean.TRUE);
        return true;
    }

    @EventListener
    public void onApplicationSetup(ApplicationSetupEvent event) {
        this.applicationSetup = event.getNewValue();
    }

    private boolean shouldRedirect(HttpServletRequest request) {
        return !SETUP_PATH.equalsIgnoreCase(this.getRequestPath(request)) && !Boolean.TRUE.equals(request.getAttribute(SETUP_ATTRIBUTE)) && !XsrfTokenInterceptor.isForwarded((HttpServletRequest)request);
    }

    private String getRequestPath(HttpServletRequest request) {
        return (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
    }
}

