/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.users.AbstractProfileController;
import com.atlassian.stash.internal.web.util.ResponseFactory;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/users/{userSlug}"})
public class UserProfileController
extends AbstractProfileController {
    private final InternalAvatarService avatarService;
    private final NavBuilder navBuilder;

    @Autowired
    public UserProfileController(I18nService i18nService, StashAuthenticationContext authenticationContext, InternalProjectService projectService, UserService userService, InternalAvatarService avatarService, NavBuilder navBuilder) {
        super(i18nService, authenticationContext, projectService, userService);
        this.avatarService = avatarService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(value={"/avatar.png"}, method={RequestMethod.GET}, produces={"image/png"})
    public void retrieveAvatar(@PathVariable(value="userSlug") String userSlug, @RequestParam(defaultValue="256", value="s") int size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StashUser user = this.userService.getUserBySlug(userSlug);
        if (user == null) {
            this.streamAvatar(this.avatarService.getUserDefault(size), request, response);
        } else {
            this.retrieveAvatar(user, size, request, response);
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showProfile(@PathVariable(value="userSlug") String slug) {
        return this.showProfile(this.getUser(slug));
    }

    @IgnoresXsrf
    @RequestMapping(value={"/avatar.png"}, consumes={"application/x-www-form-urlencoded"}, method={RequestMethod.POST})
    public ResponseEntity<Void> uploadAvatar(@PathVariable(value="userSlug") String slug, @RequestParam(value="avatar") String uri) {
        StashUser user = this.getUser(slug);
        this.userService.updateAvatar(user, uri);
        return ResponseFactory.created((String)this.navBuilder.user(user).avatar(256).buildAbsolute());
    }

    @Nonnull
    private StashUser getUser(String slug) {
        StashUser user = this.userService.getUserBySlug(slug);
        if (user == null) {
            throw this.newNoSuchUserBySlugException(slug);
        }
        return user;
    }
}

