/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.startup;

import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import com.atlassian.stash.internal.lifecycle.StartupUtils;
import com.atlassian.stash.internal.rest.RestProgress;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;

public class StartupServlet
extends HttpServlet {
    private static final JsonFactory JSON = new MappingJsonFactory();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StartupManager startupManager = StartupUtils.getStartupManager((ServletContext)this.getServletContext());
        if ("application/json".equals(request.getHeader("Accept"))) {
            response.setStatus(200);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            JsonGenerator jsonGenerator = JSON.createJsonGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);
            jsonGenerator.writeObject((Object)ImmutableMap.of((Object)"progress", (Object)new RestProgress(startupManager.getProgress()), (Object)"state", (Object)LifecycleUtils.getCurrentState((ServletContext)this.getServletContext())));
            jsonGenerator.close();
        } else if (startupManager.isStarting()) {
            request.getRequestDispatcher("/startup.jsp").forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(request.getContextPath());
        }
    }
}

