/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.soy.functions.AbstractWebFragmentFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebItemFunction
extends AbstractWebFragmentFunction<WebItemData> {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)1, (int)2);

    public WebItemFunction(WebInterfaceManager webInterfaceManager, StashAuthenticationContext authenticationContext, HttpContext httpContext) {
        super(webInterfaceManager, authenticationContext, httpContext);
    }

    public String getName() {
        return "getWebItems";
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("WebFragments.getWebItems(" + args[0].getText() + (args.length > 1 ? "," + args[1].getText() : "") + ")");
    }

    public List<WebItemData> apply(Object ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (Object)"invalid number of arguments");
        String location = (String)Preconditions.checkNotNull((Object)args[0]);
        HashMap context = args.length == 2 && args[1] != null ? (Map)args[1] : Maps.newHashMap();
        return this.getWebItems(location, (Map)context);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

