/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.SanitizationType;
import com.atlassian.soy.renderer.SanitizedString;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.markup.MarkupService;
import com.atlassian.stash.markup.RenderContext;
import com.atlassian.stash.markup.UrlMode;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RenderFunction
implements SoyServerFunction<SanitizedString> {
    private static final ImmutableSet<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)1, (Object)2);
    private final MarkupService markupRenderService;

    public RenderFunction(MarkupService markupRenderService) {
        this.markupRenderService = markupRenderService;
    }

    public SanitizedString apply(Object ... args) {
        RenderContext context = args.length > 1 ? this.parseOptions(args[1]) : new RenderContext.Builder().build();
        return new SanitizedString(this.markupRenderService.render((String)args[0], context), SanitizationType.HTML);
    }

    public String getName() {
        return "render";
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }

    private RenderContext parseOptions(Object arg) {
        RenderContext.Builder contextBuilder = new RenderContext.Builder();
        if (arg instanceof String) {
            contextBuilder = contextBuilder.urlMode(UrlMode.valueOf((String)((String)arg).toUpperCase(Locale.US)));
        } else {
            Map opts = (Map)arg;
            String urlMode = (String)opts.get("urlMode");
            Boolean hardwrap = (Boolean)opts.get("hardwrap");
            Boolean htmlEscape = (Boolean)opts.get("htmlEscape");
            if (urlMode != null) {
                contextBuilder = contextBuilder.urlMode(UrlMode.valueOf((String)urlMode.toUpperCase(Locale.US)));
            }
            if (hardwrap != null) {
                contextBuilder = contextBuilder.hardwrap(hardwrap.booleanValue());
            }
            if (htmlEscape != null) {
                contextBuilder = contextBuilder.htmlEscape(htmlEscape.booleanValue());
            }
        }
        return contextBuilder.build();
    }
}

