/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.content.Path;
import com.atlassian.stash.content.SimplePath;
import com.atlassian.stash.content.Submodule;
import com.atlassian.stash.internal.web.repos.ViewRef;
import com.atlassian.stash.nav.NavBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public class ViewFile
implements Comparable<ViewFile> {
    private final ContentTreeNode.Type type;
    private final String name;
    private final String url;
    private final String repositoryUrl;
    private final String browseUrl;
    private final String contentId;

    public static ViewFile create(ContentTreeNode contentTreeNode, String project, String repo, String path, ViewRef ref, NavBuilder navBuilder) {
        if (contentTreeNode.getType() != ContentTreeNode.Type.SUBMODULE) {
            NavBuilder.PathBuilder pathBuilder = navBuilder.project(project).repo(repo).browse().path((Path)new SimplePath((CharSequence)(path + "/" + contentTreeNode.getPath().getName())));
            if (!ref.isDefault()) {
                pathBuilder.withParam("at", ref.getType().isCommit() ? ref.getId() : ref.getDisplayId());
            }
            return new ViewFile(contentTreeNode, pathBuilder.buildRelative(), null, null);
        }
        Submodule submodule = (Submodule)contentTreeNode;
        return new ViewFile(contentTreeNode, submodule.getUrl(), submodule.getRepositoryUrl(), submodule.getBrowseUrl());
    }

    @VisibleForTesting
    protected ViewFile(ContentTreeNode contentTreeNode, String url, String repositoryUrl, String browseUrl) {
        this.type = contentTreeNode.getType();
        this.name = contentTreeNode.getPath().getName();
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
        this.repositoryUrl = repositoryUrl;
        this.browseUrl = browseUrl;
        this.contentId = contentTreeNode.getContentId();
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getBrowseUrl() {
        return this.browseUrl;
    }

    public String getContentId() {
        return this.contentId;
    }

    public ContentTreeNode.Type getType() {
        return this.type;
    }

    public ContentTreeNode.Type getTypeValue() {
        return this.type;
    }

    @Override
    public int compareTo(ViewFile o) {
        if (this.getTypeValue() == ContentTreeNode.Type.DIRECTORY ^ o.getTypeValue() == ContentTreeNode.Type.DIRECTORY) {
            return this.getTypeValue() == ContentTreeNode.Type.DIRECTORY ? -1 : 1;
        }
        int i = this.getName().compareToIgnoreCase(o.getName());
        return i == 0 ? this.getName().compareTo(o.getName()) : i;
    }
}

