/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.stash.commit.CommitService;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.exception.NoDefaultBranchException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/compare"})
public class CompareController
extends RepositoryControllerSupport {
    private static final String COMPARE_PAGE = "stash.page.compare";
    private final CommitService commitService;
    @Value(value="${page.max.changes}")
    private int maxChanges;

    @Autowired
    public CompareController(I18nService i18nService, InternalProjectService projectService, RepositoryService repositoryService, RepositoryMetadataService metadataService, PermissionService permissionService, CommitService commitService) {
        super(i18nService, projectService, repositoryService, metadataService, permissionService);
        this.commitService = commitService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView compare(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId) {
        return this.compareCommits(projectKey, repoSlug, fromBranch, toBranch, targetRepoId);
    }

    @RequestMapping(value={"/diff"}, method={RequestMethod.GET})
    public ModelAndView compareDiff(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId) {
        return this.compareView(projectKey, repoSlug, fromBranch, toBranch, targetRepoId, "compare-diff-tab");
    }

    @RequestMapping(value={"/commits"}, method={RequestMethod.GET})
    public ModelAndView compareCommits(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId) {
        return this.compareView(projectKey, repoSlug, fromBranch, toBranch, targetRepoId, "compare-commits-tab");
    }

    private ModelAndView compareView(String projectKey, String repoSlug, String sourceBranchSpec, String toBranch, int targetRepoId, String activeTab) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        Ref sourceRef = this.metadataService.resolveRef(repository, sourceBranchSpec);
        Changeset sourceChangeset = null;
        if (sourceRef != null) {
            sourceChangeset = this.commitService.getChangeset(repository, sourceRef.getLatestChangeset());
        }
        Repository targetRepository = this.getTargetRepository(repository, targetRepoId);
        Ref targetRef = this.getBranchOrDefault(targetRepository, toBranch);
        Changeset targetChangeset = null;
        if (sourceRef != null) {
            targetChangeset = this.commitService.getChangeset(targetRepository, targetRef.getLatestChangeset());
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(COMPARE_PAGE).put("activeTab", (Object)activeTab)).put("targetRepository", (Object)targetRepository)).putIfNotNull("targetBranch", (Object)targetRef).putIfNotNull("targetChangeset", (Object)targetChangeset).put("sourceRepository", (Object)repository)).putIfNotNull("sourceBranch", (Object)sourceRef).putIfNotNull("sourceChangeset", (Object)sourceChangeset).put("maxChanges", (Object)this.maxChanges)).build();
    }

    private Ref getBranchOrDefault(Repository repository, String toBranch) {
        Ref targetBranch = this.metadataService.resolveRef(repository, toBranch);
        try {
            targetBranch = targetBranch == null ? this.metadataService.getDefaultBranch(repository) : targetBranch;
        }
        catch (NoDefaultBranchException e) {
            // empty catch block
        }
        return targetBranch;
    }
}

