/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.onboarding;

import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/getting-started"})
public class GettingStartedController {
    private static final String NEXT_URL = "nextUrl";
    static final String GETTING_STARTED = "stash.onboarding.gettingstarted";
    static final String WAS_REDIRECTED = "wasRedirected";
    private final InternalUserSettingsService userSettingsService;
    private final StashAuthenticationContext authenticationContext;

    @Autowired
    public GettingStartedController(InternalUserSettingsService userSettingsService, StashAuthenticationContext authenticationContext) {
        this.userSettingsService = userSettingsService;
        this.authenticationContext = authenticationContext;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView gettingStarted(@RequestParam(value="next", required=false) String nextUrl, @RequestHeader(value="referer", required=false) String referrer, HttpServletRequest request) {
        StashSoyResponseBuilder builder = new StashSoyResponseBuilder(GETTING_STARTED);
        builder.put(WAS_REDIRECTED, (Object)this.showGettingStarted());
        if (StringUtils.isBlank((CharSequence)nextUrl)) {
            nextUrl = StringUtils.isBlank((CharSequence)referrer) ? request.getContextPath() : URIUtil.getPathQuery((String)referrer);
        }
        builder.put(NEXT_URL, (Object)(nextUrl.contains("/getting-started") ? request.getContextPath() : nextUrl));
        return builder.build();
    }

    private boolean showGettingStarted() {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        UserSettings userSettings = this.userSettingsService.getUserSettings(currentUser);
        boolean showGettingStarted = (Boolean)userSettings.getBoolean(ApplicationConstants.SHOW_GETTING_STARTED_PAGE_KEY).getOrElse((Object)false);
        if (showGettingStarted) {
            this.userSettingsService.updateUserSettings(currentUser, (Function)new /* Unavailable Anonymous Inner Class!! */);
        }
        return showGettingStarted;
    }
}

