/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.i18n;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.stash.i18n.I18nService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;

public class JavascriptI18NWebResourceTransformer
implements WebResourceTransformer {
    private static final Pattern PATTERN = Pattern.compile("(?:cav_i18n|stash_i18n)\\(\\s*(['\"])([\\w.-]+)\\1\\s*,\\s*(['\"])(.*?)\\3\\s*([\\),])");
    private final I18nService i18nService;

    public JavascriptI18NWebResourceTransformer(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public DownloadableResource transform(Element configElement, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String transform(CharSequence originalContent) {
        Matcher matcher = PATTERN.matcher(originalContent);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(2);
            String enText = StringEscapeUtils.unescapeJavaScript((String)matcher.group(4));
            boolean format = ",".equals(matcher.group(5));
            matcher.appendReplacement(result, "");
            if (format) {
                result.append("AJS.format(");
                result.append("'").append(StringEscapeUtils.escapeJavaScript((String)this.i18nService.getMessagePattern(key, enText))).append("'");
                result.append(",");
                continue;
            }
            result.append("'").append(StringEscapeUtils.escapeJavaScript((String)this.i18nService.getText(key, enText, new Object[0]))).append("'");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

