/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.help;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.stash.help.HelpPathService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;

public class JavascriptHelpUrlWebResourceTransformer
implements WebResourceTransformer {
    private static final Pattern PATTERN = Pattern.compile("(?:cav_help_url|stash_help_url)\\(\\s*(['\"])([\\w.-]+)\\1\\s*\\)");
    private final HelpPathService helpPathService;

    public JavascriptHelpUrlWebResourceTransformer(HelpPathService helpPathService) {
        this.helpPathService = helpPathService;
    }

    public DownloadableResource transform(Element configElement, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String transform(CharSequence originalContent) {
        Matcher matcher = PATTERN.matcher(originalContent);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String helpPageUrl = this.helpPathService.getPageUrl(matcher.group(2));
            matcher.appendReplacement(result, "");
            result.append("'").append(StringEscapeUtils.escapeJavaScript((String)(helpPageUrl == null ? "" : helpPageUrl))).append("'");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

