/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.fragments;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.watcher.Watchable;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class IsWatchingContextProvider
implements ContextProvider {
    private final StashAuthenticationContext authenticationContext;
    private final InternalWatcherService watcherService;

    public IsWatchingContextProvider(StashAuthenticationContext authenticationContext, InternalWatcherService watcherService) {
        this.authenticationContext = authenticationContext;
        this.watcherService = watcherService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        boolean isWatching = false;
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null) {
            Changeset changeset;
            Watchable watchable = (Watchable)context.get("watchable");
            isWatching = watchable != null ? this.watcherService.isCurrentUserWatching(watchable) : (changeset = (Changeset)context.get("changeset")) != null && currentUser.getEmailAddress().equals(changeset.getAuthor().getEmailAddress());
        }
        return ImmutableMap.of((Object)"isWatching", (Object)isWatching);
    }
}

