/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.google.common.collect.Maps;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.filter.PageFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="sitemesh")
public class PluginDecorationFilter
extends PageFilter {
    private static final String DECORATOR_MODULE_KEY = "com.atlassian.stash.stash-web-plugin:server-soy-decorators";
    private static final Logger log = LoggerFactory.getLogger(PluginDecorationFilter.class);
    private final SoyTemplateRenderer templateRenderer;
    private final InjectedDataFactory injectedDataFactory;
    private final InternalProjectService projectService;
    private final RepositoryService repositoryService;
    private final PullRequestService pullRequestService;
    private final UserService userService;
    @Value(value="${page.max.changes}")
    private int maxChanges;

    @Autowired
    public PluginDecorationFilter(SoyTemplateRenderer templateRenderer, InjectedDataFactory injectedDataFactory, InternalProjectService projectService, RepositoryService repositoryService, PullRequestService pullRequestService, UserService userService) {
        this.templateRenderer = templateRenderer;
        this.injectedDataFactory = injectedDataFactory;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.pullRequestService = pullRequestService;
        this.userService = userService;
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StashSoyResponseBuilder dataBuilder = new StashSoyResponseBuilder("");
        if (page instanceof HTMLPage) {
            HTMLPage htmlPage = (HTMLPage)page;
            dataBuilder.put("head", (Object)htmlPage.getHead());
        }
        dataBuilder.put("title", (Object)page.getTitle());
        dataBuilder.put("body", (Object)page.getBody());
        HashMap properties = Maps.newHashMap();
        for (String key : page.getPropertyKeys()) {
            properties.put(key, page.getProperty(key));
        }
        this.applyStashDecoratorData(page, dataBuilder);
        dataBuilder.put("properties", (Object)properties);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try {
            this.templateRenderer.render((Appendable)response.getWriter(), DECORATOR_MODULE_KEY, decorator.getPage(), dataBuilder.build().getModel(), this.injectedDataFactory.createInjectedData(request));
        }
        catch (SoyException e) {
            throw new ServletException("error rendering decorator '" + decorator.getPage() + "'", (Throwable)e);
        }
    }

    protected void applyStashDecoratorData(Page page, StashSoyResponseBuilder dataBuilder) {
        String projectKey = page.getProperty("meta.projectKey");
        String repoSlug = page.getProperty("meta.repositorySlug");
        String pullRequestId = page.getProperty("meta.pullRequestId");
        String userSlug = page.getProperty("meta.userSlug");
        if (StringUtils.isNotEmpty((String)userSlug)) {
            StashUser user = this.userService.getUserBySlug(userSlug);
            if (user != null) {
                dataBuilder.put("user", (Object)user);
                String userProjectKey = InternalPersonalProject.createPersonalProjectKey((StashUser)user);
                if (projectKey != null && !userProjectKey.equalsIgnoreCase(projectKey)) {
                    log.error("Both userSlug and projectKey were specified to the decorator, user's personal project {} is going to stomp {}", (Object)userProjectKey, (Object)projectKey);
                }
                PersonalProject project = this.projectService.getPersonalProject(user);
                dataBuilder.putProject((Project)project);
            }
        } else if (!StringUtils.isEmpty((String)projectKey)) {
            Project project = null;
            if (!StringUtils.isEmpty((String)repoSlug)) {
                Repository repo = this.repositoryService.getBySlug(projectKey, repoSlug);
                if (repo != null) {
                    project = repo.getProject();
                    if (!StringUtils.isEmpty((String)pullRequestId)) {
                        PullRequest pullRequest = this.pullRequestService.getById(repo.getId().intValue(), Long.parseLong(pullRequestId));
                        if (pullRequest != null) {
                            dataBuilder.putPullRequest(pullRequest);
                        }
                        dataBuilder.put("maxChanges", (Object)this.maxChanges);
                    }
                    dataBuilder.putRepository(repo);
                }
            } else {
                project = this.projectService.getByKey(projectKey);
            }
            if (project != null) {
                dataBuilder.putProject(project);
            }
        }
    }
}

