/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.stash.internal.web.HttpRequestInfoHelper;
import com.atlassian.stash.internal.web.util.UriEncodingUtils;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="authenticationAttributeFilter")
public class AuthenticationAttributeFilter
extends OncePerRequestFilter {
    static final String X_AUSERNAME = "X-AUSERNAME";
    static final String X_AUSERID = "X-AUSERID";
    private final StashAuthenticationContext authenticationContext;
    private final HttpRequestInfoHelper helper;

    @Autowired
    public AuthenticationAttributeFilter(StashAuthenticationContext authenticationContext, HttpRequestInfoHelper helper) {
        this.authenticationContext = authenticationContext;
        this.helper = helper;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String sessionId;
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            response.setHeader(X_AUSERNAME, UriEncodingUtils.encodeURIComponent((String)user.getName(), (String)"UTF-8"));
            response.setHeader(X_AUSERID, String.valueOf(user.getId()));
            MDC.put((String)"a-username", (String)user.getName());
        }
        if ((sessionId = this.helper.getSessionId(request)) != null) {
            if (!response.containsHeader("X-ASESSIONID")) {
                response.setHeader("X-ASESSIONID", sessionId);
            }
            MDC.put((String)"a-session-id", (String)sessionId);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

