/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.auth;

import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.auth.AuthenticationHelper;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    public static final String LOGIN = "stash.auth.login";
    private final StashAuthenticationContext authenticationContext;
    private final AuthenticationHelper authenticationHelper;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public LoginController(StashAuthenticationContext authenticationContext, AuthenticationHelper authenticationHelper, I18nService i18nService, NavBuilder navBuilder, ApplicationPropertiesService propertiesService) {
        this.authenticationContext = authenticationContext;
        this.authenticationHelper = authenticationHelper;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView login(@RequestParam(value="next", required=false) String nextUrl, HttpServletRequest request) {
        String lastUsername;
        if (this.authenticationContext.isAuthenticated()) {
            if (StringUtils.isNotBlank((String)nextUrl)) {
                return new ModelAndView((View)new RedirectView(nextUrl, true));
            }
            return new ModelAndView((View)new RedirectView(this.navBuilder.buildAbsolute()));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        AuthenticationException authenticationException = this.authenticationHelper.getAuthenticationException(request);
        if (authenticationException != null) {
            if (authenticationException.getCause() instanceof ServiceException) {
                builder.put((Object)"error", (Object)authenticationException.getCause().getLocalizedMessage());
            } else if (authenticationException instanceof CookieTheftException) {
                builder.put((Object)"error", (Object)this.i18nService.getMessage("stash.web.login.invalid.rememberme", new Object[0]));
            } else {
                builder.put((Object)"error", (Object)authenticationException.getLocalizedMessage());
                log.warn("Authentication failed with an unexpected error type", (Throwable)authenticationException);
            }
            this.authenticationHelper.setAuthenticationException(request, null);
        }
        if (StringUtils.isNotEmpty((String)(lastUsername = this.authenticationHelper.getCachedUsername(request)))) {
            builder.put((Object)"lastUsername", (Object)lastUsername);
        }
        builder.put((Object)"allowSignUp", (Object)this.propertiesService.isAllowPublicSignUp());
        builder.put((Object)"showCaptcha", (Object)(authenticationException instanceof LockedException));
        if (StringUtils.isNotEmpty((String)nextUrl)) {
            builder.put((Object)"nextUrl", (Object)nextUrl);
        }
        return new ModelAndView(LOGIN, (Map)builder.build());
    }
}

