/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.exception.MailException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.mail.InternalMailService;
import com.atlassian.stash.internal.web.admin.MailServerConfigurationController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.mail.MailHostConfiguration;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.stash.server.ApplicationPropertiesService;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/admin/mail-server"})
public final class MailServerConfigurationController {
    private static final Logger LOG = LoggerFactory.getLogger(MailServerConfigurationController.class);
    private static final String VIEW = "stash.admin.mailserverconfig";
    private static final String REDIRECT_URL = "redirect:/admin/mail-server";
    private final I18nService i18nService;
    private final InternalMailService mailService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public MailServerConfigurationController(InternalMailService mailService, I18nService i18nService, ApplicationPropertiesService propertiesService) {
        this.mailService = mailService;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showSettings() {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.admin.mailserverconfig").put("isConfigured", (Object)this.mailService.isHostConfigured())).put("config", (Object)this.loadConfig())).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView updateSettings(@Valid Form config, Errors errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.admin.mailserverconfig").put("config", (Object)config)).putValidationErrors(errors).build();
        }
        this.updateConfig(config);
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new ModelAndView("redirect:/admin/mail-server");
    }

    @RequestMapping(method={RequestMethod.POST}, params={"test"})
    public ModelAndView testSettings(@Valid TestForm config, Errors errors) {
        StashSoyResponseBuilder rb = (StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.admin.mailserverconfig").put("config", (Object)config);
        if (errors.hasErrors()) {
            return rb.putValidationErrors(errors).build();
        }
        try {
            this.mailService.sendTest(new MailHostConfiguration(config.getHostname(), this.parsePort(config.getPort()), config.getUsername(), config.getPassword(), config.isUseTls()), new MailMessage.Builder().subject(this.i18nService.getMessage("stash.web.admin.mail.test.subject", new Object[]{this.propertiesService.getDisplayName()})).text(this.i18nService.getMessage("stash.web.admin.mail.test.body", new Object[]{this.propertiesService.getDisplayName()})).to(new String[]{config.getTestAddress()}).from(config.getServerEmail()).build());
            return ((StashSoyResponseBuilder)rb.put("tested", (Object)true)).build();
        }
        catch (MailException e) {
            LOG.warn(String.format("Failed to send a test email message to %s", config.getTestAddress()), (Throwable)e);
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)rb.put("tested", (Object)true)).put("testFailureMessage", (Object)e.getLocalizedMessage())).build();
        }
    }

    private Form loadConfig() {
        MailHostConfiguration configuration = this.propertiesService.getMailHostConfiguration();
        Form form = new Form();
        if (configuration != null) {
            Form.access$002((Form)form, (String)configuration.getHostname());
            Form.access$102((Form)form, configuration.getPort() != null ? configuration.getPort().toString() : null);
            Form.access$202((Form)form, (String)configuration.getUsername());
            Form.access$302((Form)form, (String)configuration.getPassword());
            Form.access$402((Form)form, (String)this.propertiesService.getServerEmailAddress());
            Form.access$502((Form)form, (boolean)configuration.isUseTls());
        }
        return form;
    }

    private void updateConfig(Form form) {
        this.propertiesService.setMailHostConfiguration(new MailHostConfiguration.Builder().hostname(form.getHostname()).port(this.parsePort(form.getPort())).username(form.getUsername()).password(form.getPassword()).useTls(form.isUseTls()).build());
        this.propertiesService.setServerEmailAddress(form.getServerEmail());
    }

    private Integer parsePort(String port) {
        return port != null ? Integer.valueOf(Integer.parseInt(port)) : null;
    }
}

