/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.web.admin.BasePermissionController;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.internal.web.widgets.permissions.PermissionData;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import java.util.ArrayList;
import java.util.List;

abstract class BasePermissionController
extends ControllerSupport {
    protected static final String GLOBAL_PERMISSIONS = "stash.admin.globalPermissions";
    protected final PermissionAdminService permissionAdminService;
    protected final I18nService i18nService;

    public BasePermissionController(PermissionAdminService permissionAdminService, I18nService i18nService) {
        super(i18nService);
        this.permissionAdminService = permissionAdminService;
        this.i18nService = i18nService;
    }

    protected List<PermissionData> getPermissionData(Permission ... permissions) {
        ArrayList<PermissionData> permissionDataList = new ArrayList<PermissionData>(permissions.length);
        for (Permission globalPermission : permissions) {
            I18nStrings strings = this.getI18nStringsFor(globalPermission);
            PermissionData permissionData = new PermissionData(globalPermission, strings.getName(), strings.getDescription());
            permissionDataList.add(permissionData);
        }
        return permissionDataList;
    }

    private I18nStrings getI18nStringsFor(Permission permission) {
        I18nStrings strings;
        switch (1.$SwitchMap$com$atlassian$stash$user$Permission[permission.ordinal()]) {
            case 1: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.sysadmin", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.sysadmin.description", new Object[]{ApplicationConstants.PRODUCT_NAME}), null);
                break;
            }
            case 2: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.admin", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.admin.description", new Object[]{ApplicationConstants.PRODUCT_NAME}), null);
                break;
            }
            case 3: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.project.create", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.project.create.description", new Object[0]), null);
                break;
            }
            case 4: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.licensed", new Object[]{ApplicationConstants.PRODUCT_NAME}), this.i18nService.getMessage("stash.web.global.permission.licensed.description", new Object[]{ApplicationConstants.PRODUCT_NAME}), null);
                break;
            }
            case 5: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.project.read", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.project.read.description", new Object[0]), null);
                break;
            }
            case 6: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.project.write", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.project.write.description", new Object[0]), null);
                break;
            }
            case 7: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.project.administer", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.project.administer.description", new Object[0]), null);
                break;
            }
            case 8: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.repo.read", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.repo.read.description", new Object[0]), null);
                break;
            }
            case 9: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.repo.write", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.repo.write.description", new Object[0]), null);
                break;
            }
            case 10: {
                strings = new I18nStrings(this.i18nService.getMessage("stash.web.global.permission.repo.administer", new Object[0]), this.i18nService.getMessage("stash.web.global.permission.repo.administer.description", new Object[0]), null);
                break;
            }
            default: {
                throw new IllegalArgumentException("No i18n name for " + permission.name());
            }
        }
        return strings;
    }
}

