/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DevelopmentWebResourceTransformer
implements WebResourceTransformer {
    protected static final String OPTIONAL_TRANSFORMERS = "stash.dev.web.transformers";
    private final LazyReference<List<WebResourceTransformer>> transformers = new /* Unavailable Anonymous Inner Class!! */;
    private final PluginAccessor pluginAccessor;

    public DevelopmentWebResourceTransformer(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public DownloadableResource transform(Element element, ResourceLocation resourceLocation, String s, DownloadableResource downloadableResource) {
        DownloadableResource nextDownloadableResource = downloadableResource;
        for (WebResourceTransformer transformer : (List)this.transformers.get()) {
            nextDownloadableResource = transformer.transform(element, resourceLocation, s, nextDownloadableResource);
        }
        return nextDownloadableResource;
    }

    private List<WebResourceTransformer> lookUpTransformers() {
        String combiner = System.getProperty(OPTIONAL_TRANSFORMERS, "");
        if (StringUtils.isEmpty((String)combiner)) {
            return Collections.emptyList();
        }
        ArrayList<WebResourceTransformer> cybertron = new ArrayList<WebResourceTransformer>();
        HashSet transformerSet = Sets.newHashSet((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)combiner));
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebResourceTransformerModuleDescriptor.class);
        for (WebResourceTransformerModuleDescriptor descriptor : moduleDescriptors) {
            if (!transformerSet.contains(descriptor.getKey())) continue;
            cybertron.add(descriptor.getModule());
        }
        return Collections.unmodifiableList(cybertron);
    }

    static /* synthetic */ List access$000(DevelopmentWebResourceTransformer x0) {
        return x0.lookUpTransformers();
    }
}

