/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.security.random.SecureRandomFactory;
import com.atlassian.stash.internal.web.DefaultHttpRequestInfoHelper;
import com.atlassian.stash.internal.web.HttpRequestInfoHelper;
import com.atlassian.stash.request.RequestInfoProvider;
import java.security.SecureRandom;
import java.util.zip.CRC32;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="httpRequestInfoHelper")
public class DefaultHttpRequestInfoHelper
implements HttpRequestInfoHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpRequestInfoHelper.class);
    static final String ATTR_SESSION_ID = "stash.session-id";
    private final SecureRandom secureRandom = SecureRandomFactory.newInstance();

    public RequestInfoProvider createRequestInfoProvider(HttpServletRequest request, HttpServletResponse response) {
        return new HttpRequestInfoProvider(this, request, response, null);
    }

    public String getRemoteAddress(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        String header = request.getHeader("X-Forwarded-For");
        if (header != null) {
            builder.append(header).append(",");
        }
        builder.append(request.getRemoteAddr());
        return builder.toString().replaceAll("\\s", "");
    }

    public String getRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (StringUtils.isNotBlank((String)request.getContextPath())) {
            url = url.substring(request.getContextPath().length());
        }
        return url;
    }

    public String getSessionId(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String sessionId = null;
        try {
            sessionId = (String)session.getAttribute(ATTR_SESSION_ID);
            if (sessionId == null) {
                byte[] bytes = new byte[40];
                this.secureRandom.nextBytes(bytes);
                CRC32 crc = new CRC32();
                crc.update(bytes);
                sessionId = Long.toString(crc.getValue(), 36);
                session.setAttribute(ATTR_SESSION_ID, (Object)sessionId);
            }
        }
        catch (IllegalStateException e) {
            log.debug("Could not retrieve sessionId: {0}", (Object)StringUtils.defaultString((String)e.getMessage()));
        }
        return sessionId;
    }
}

