/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class RememberMeAuthenticationProviderImpl
extends RememberMeAuthenticationProvider {
    private final I18nService i18nService;
    private final InternalPermissionService permissionService;
    private final UserService userService;

    public RememberMeAuthenticationProviderImpl(String key, I18nService i18nService, InternalPermissionService permissionService, UserService userService) {
        super(key);
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.userService = userService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication token = super.authenticate(authentication);
        if (token == null) {
            return null;
        }
        StashUser user = this.userService.getUserByName(token.getName());
        if (user == null || !user.isActive()) {
            throw new AccountExpiredException(this.i18nService.getMessage("stash.web.user.inactive", new Object[]{token.getName()}));
        }
        StashUserAuthenticationToken authenticationToken = StashUserAuthenticationToken.forUser((StashUser)user);
        if (!this.permissionService.hasGlobalPermission(authenticationToken, Permission.LICENSED_USER)) {
            throw new DisabledException("User does not have permission to access this system");
        }
        return authenticationToken;
    }
}

