/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.lifecycle;

import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.atlassian.stash.Product;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStartupManager
implements StartupManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultStartupManager.class);
    private final ServletContext servletContext;
    private volatile Progress progress;

    public DefaultStartupManager(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.progress = new ProgressImpl("Starting " + Product.FULL_NAME, 0);
    }

    @Nonnull
    public Progress getProgress() {
        return this.progress;
    }

    public boolean isStarting() {
        return LifecycleUtils.isStarting((ServletContext)this.servletContext);
    }

    public void onProgress(@Nonnull Progress progress) {
        Progress oldProgress = this.progress;
        if (progress.getPercentage() < oldProgress.getPercentage()) {
            log.debug("Progress going backwards: {} {}% -> {} {}%!", new Object[]{oldProgress.getMessage(), oldProgress.getPercentage(), progress.getMessage(), progress.getPercentage()});
        }
        this.progress = progress;
    }
}

