/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson.handler.bean;

import com.atlassian.stash.Product;
import com.atlassian.stash.internal.johnson.AbstractHelpPathProvider;
import com.atlassian.stash.internal.johnson.handler.EventDetails;
import com.atlassian.stash.internal.johnson.handler.bean.BeanFailureHandler;
import com.google.common.base.Throwables;
import java.sql.SQLException;
import java.util.Locale;
import javax.annotation.Nonnull;
import liquibase.exception.LockException;
import org.springframework.beans.factory.BeanCreationException;

public class LiquibaseFailureHandler
extends AbstractHelpPathProvider
implements BeanFailureHandler {
    public EventDetails handle(@Nonnull BeanCreationException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof LockException) {
            return this.handle((LockException)cause);
        }
        return new EventDetails("schema-update-failed", "The database schema could not be updated. Details about the change that failed can be found in the logs.<br/><br/>It may be necessary to <a href=\"https://support.atlassian.com\">create a ticket</a> to resolve the error. When creating a ticket, please include the exception details from the logs, as well as the database type.", cause);
    }

    private EventDetails handle(@Nonnull LockException exception) {
        String description;
        Throwable rootCause = Throwables.getRootCause((Throwable)exception);
        if (rootCause instanceof SQLException && (description = rootCause.getMessage().toLowerCase(Locale.US)).contains("innodb") && description.contains("binary logging not possible")) {
            AbstractHelpPathProvider.HelpDetails help = this.getHelp("stash.kb.db.mysql.binarylog", "our documentation", "https://confluence.atlassian.com/x/VYLlFw");
            StringBuilder message = new StringBuilder("The binary log format used by MySQL is not compatible with ").append(Product.NAME).append(".<br/><br/>").append("See <a href=\"").append(help.getUrl()).append("\">").append(help.getTitle()).append("</a> for more information.");
            return new EventDetails("database-mysql-binary-log", message.toString(), (Throwable)exception);
        }
        AbstractHelpPathProvider.HelpDetails help = this.getHelp("stash.kb.db.schema.locked", "our knowledge base", "https://confluence.atlassian.com/x/cRivEg");
        return new EventDetails("schema-locked", "The database schema could not be locked for update. This typically means " + Product.NAME + " was interrupted during a previous attempt to update the schema." + "<br/><br/>See <a href=\"" + help.getUrl() + "\">" + help.getTitle() + "</a> for directions to manually unlock the schema.", (Throwable)exception);
    }
}

