/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.ApplicationEventCheck;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.Product;
import com.atlassian.stash.internal.johnson.AbstractHelpPathProvider;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;

public class LocaleApplicationEventCheck
extends AbstractHelpPathProvider
implements ApplicationEventCheck {
    private static final String TURKISH_ISO_CODE = "tur";
    private static final Set<String> UNSUPPORTED_LOCALES = ImmutableSet.of((Object)"tur");

    public void check(JohnsonEventContainer eventContainer, ServletContext context) {
        Locale locale = Locale.getDefault();
        this.check(eventContainer, locale);
    }

    protected void check(JohnsonEventContainer eventContainer, Locale locale) {
        if (UNSUPPORTED_LOCALES.contains(locale.getISO3Language())) {
            eventContainer.addEvent(this.createEvent(locale));
        }
    }

    private Event createEvent(Locale locale) {
        AbstractHelpPathProvider.HelpDetails help = this.getHelp("stash.kb.db.failure.with.turkish.locale", "knowledge base article", "https://confluence.atlassian.com/x/uIKZGQ");
        String description = String.format("The current locale (%2$s) is not supported by %1$s.%nPlease follow the instructions in this <a href=\"%3$s\">knowledge base article</a> to resolve the issue.", Product.NAME, locale.getDisplayName(), help.getUrl());
        return new Event(EventType.get((String)"unsupported-locale"), description, EventLevel.get((String)"fatal"));
    }
}

