/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.stash.internal.johnson.filters.BypassableJohnsonFilter;
import com.atlassian.stash.internal.maintenance.SystemMaintenanceEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.Conventions;

/*
 * Exception performing whole class analysis ignored.
 */
public class JohnsonBypassHelper {
    public static final String ATTR_BYPASSED = Conventions.getQualifiedAttributeName(BypassableJohnsonFilter.class, (String)"bypassed");
    public static final String HEADER_TOKEN = "X-Atlassian-Maintenance-Token";

    private JohnsonBypassHelper() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class");
    }

    public static boolean isBypassed(ServletRequest request) {
        Object checked = request.getAttribute(ATTR_BYPASSED);
        if (checked instanceof Boolean) {
            return (Boolean)checked;
        }
        HttpServletRequest http = (HttpServletRequest)request;
        ServletContext servletContext = http.getServletContext();
        boolean bypassed = JohnsonBypassHelper.isIgnored((HttpServletRequest)http, (ServletContext)servletContext) || JohnsonBypassHelper.isBypassed((HttpServletRequest)http, (ServletContext)servletContext);
        http.setAttribute(ATTR_BYPASSED, (Object)bypassed);
        return bypassed;
    }

    private static boolean isBypassed(HttpServletRequest request, ServletContext servletContext) {
        JohnsonEventContainer eventContainer = Johnson.getEventContainer((ServletContext)servletContext);
        if (eventContainer.hasEvents()) {
            Event event;
            Collection events = eventContainer.getEvents();
            Iterator iterator = events.iterator();
            if (iterator.hasNext() && (event = (Event)iterator.next()) instanceof SystemMaintenanceEvent && !iterator.hasNext()) {
                SystemMaintenanceEvent maintenanceEvent = (SystemMaintenanceEvent)event;
                return maintenanceEvent.isToken(request.getHeader("X-Atlassian-Maintenance-Token"));
            }
            return false;
        }
        return true;
    }

    private static boolean isIgnored(HttpServletRequest request, ServletContext servletContext) {
        JohnsonConfig config = Johnson.getConfig((ServletContext)servletContext);
        return config.isIgnoredPath(StringUtils.defaultString((String)request.getServletPath()) + StringUtils.defaultString((String)request.getPathInfo()));
    }
}

