/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;

public class HasPullRequestApproveCondition
implements Condition {
    private static final String PULL_REQUEST = "pullRequest";
    private final StashAuthenticationContext authenticationContext;

    public HasPullRequestApproveCondition(StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        PullRequest pullRequest = (PullRequest)context.get(PULL_REQUEST);
        LinkedHashSet allParticipants = Sets.newLinkedHashSet();
        allParticipants.add(pullRequest.getAuthor());
        allParticipants.addAll(pullRequest.getReviewers());
        allParticipants.addAll(pullRequest.getParticipants());
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null) {
            String currentUsername = currentUser.getName();
            for (PullRequestParticipant participant : allParticipants) {
                if (!currentUsername.equals(participant.getUser().getName())) continue;
                return participant.isApproved();
            }
        }
        return false;
    }
}

