/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.project.AbstractProjectVisitor;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import java.util.Map;
import javax.annotation.Nonnull;

public class IsPersonalRepositoryCondition
implements Condition {
    public static final String REPOSITORY = "repository";
    public static final String ONLY_MINE = "onlyMine";
    private final StashAuthenticationContext authenticationContext;
    private boolean onlyMine;

    public IsPersonalRepositoryCondition(StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) {
        this.onlyMine = Boolean.parseBoolean(params.get(ONLY_MINE));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Repository repository = (Repository)context.get(REPOSITORY);
        if (repository == null) {
            return false;
        }
        return (Boolean)repository.getProject().accept((ProjectVisitor)new AbstractProjectVisitor<Boolean>(Boolean.FALSE){

            public Boolean visit(@Nonnull PersonalProject project) {
                return !IsPersonalRepositoryCondition.this.onlyMine || StashUserEquality.equals((StashUser)project.getOwner(), (Object)IsPersonalRepositoryCondition.this.authenticationContext.getCurrentUser());
            }
        });
    }
}

