/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.project.AbstractProjectVisitor;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import java.util.Map;
import javax.annotation.Nonnull;

public class IsPersonalProjectCondition
implements Condition {
    public static final String PROJECT = "project";
    public static final String ONLY_MINE = "onlyMine";
    private final StashAuthenticationContext authenticationContext;
    private boolean onlyMine;

    public IsPersonalProjectCondition(StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) {
        this.onlyMine = Boolean.parseBoolean(params.get(ONLY_MINE));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Project project = (Project)context.get(PROJECT);
        if (project == null) {
            return false;
        }
        return (Boolean)project.accept((ProjectVisitor)new AbstractProjectVisitor<Boolean>(Boolean.FALSE){

            public Boolean visit(@Nonnull PersonalProject project) {
                return !IsPersonalProjectCondition.this.onlyMine || StashUserEquality.equals((StashUser)project.getOwner(), (Object)IsPersonalProjectCondition.this.authenticationContext.getCurrentUser());
            }
        });
    }
}

