/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import java.util.Map;

public class CanEditPullRequestCondition
implements Condition {
    public static final String REPOSITORY = "repository";
    public static final String PULL_REQUEST = "pullRequest";
    protected final PermissionService permissionService;
    protected final StashAuthenticationContext authenticationContext;

    public CanEditPullRequestCondition(PermissionService permissionService, StashAuthenticationContext authenticationContext) {
        this.permissionService = permissionService;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.isAuthorOfPullRequest(context) || this.hasEditPermission(context);
    }

    protected boolean hasEditPermission(Map<String, Object> context) {
        Repository repository = (Repository)context.get(REPOSITORY);
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE);
    }

    protected boolean isAuthorOfPullRequest(Map<String, Object> context) {
        PullRequest pullRequest = (PullRequest)context.get(PULL_REQUEST);
        if (pullRequest == null) {
            throw new IllegalStateException("Condition context does not have a pullRequest object on it");
        }
        return pullRequest.getAuthor().getUser().equals(this.authenticationContext.getCurrentUser());
    }
}

