/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.repository.Repository;
import java.util.Map;

public class IsPersonalRepositoryCondition
implements Condition {
    public static final String REPOSITORY = "repository";
    private final InternalProjectService projectService;
    private boolean onlyMine;

    public IsPersonalRepositoryCondition(InternalProjectService projectService) {
        this.projectService = projectService;
    }

    public void init(Map<String, String> params) {
        this.onlyMine = Boolean.parseBoolean(params.get("onlyMine"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Repository repository = (Repository)context.get(REPOSITORY);
        if (repository == null) {
            return false;
        }
        Project project = repository.getProject();
        return this.onlyMine ? this.projectService.isPersonalProject(project.getKey()) : project.getType() == ProjectType.PERSONAL;
    }
}

