/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.util.Page;
import java.util.Map;

public class NoRepositoriesExistForProjectCondition
implements Condition {
    private static final String PROJECT = "project";
    private static final String REPOSITORY_PAGE = "repositoryPage";
    private final RepositoryService repositoryService;

    public NoRepositoriesExistForProjectCondition(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (context.containsKey(REPOSITORY_PAGE)) {
            Object repositoryPage = context.get(REPOSITORY_PAGE);
            return repositoryPage instanceof Page && ((Page)repositoryPage).getSize() == 0;
        }
        Object project = context.get(PROJECT);
        return project instanceof Project && this.repositoryService.countRepositoriesByProject((Project)project) == 0;
    }
}

