/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPermissionCondition
implements Condition {
    public static final String PERMISSION = "permission";
    protected final PermissionService permissionService;
    private final boolean global;
    private Permission permission;

    protected AbstractPermissionCondition(PermissionService permissionService, boolean global) {
        this.global = global;
        this.permissionService = permissionService;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String permissionName = params.get(PERMISSION);
        if (StringUtils.isBlank((String)permissionName)) {
            throw new PluginParseException(this.getClass().getSimpleName() + ": The [" + PERMISSION + "] param is required, and must define a " + this.getType() + " permission");
        }
        try {
            this.permission = Permission.valueOf((String)permissionName);
            Preconditions.checkArgument((this.global == this.permission.isGlobal() ? 1 : 0) != 0, (String)"%s requires a %s permission", (Object[])new Object[]{this.getClass().getSimpleName(), this.getType()});
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException(e.getMessage());
        }
    }

    protected String getType() {
        return this.global ? "global" : "non-global";
    }
}

