/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.DevModeUtils;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Timer;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class TimerUtils {
    private TimerUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static boolean isActive() {
        return UtilTimerStack.isActive();
    }

    public static Timer start(@Nonnull String name) {
        return new DefaultTimer(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T time(String name, Operation<T, E> supplier) throws E {
        UtilTimerStack.push((String)name);
        try {
            Object object = supplier.perform();
            return (T)object;
        }
        finally {
            UtilTimerStack.pop((String)name);
        }
    }

    private static class DefaultTimer
    implements Timer {
        private String currentName;
        private boolean stopped;

        private DefaultTimer(String currentName) {
            this.currentName = (String)Preconditions.checkNotNull((Object)currentName, (Object)"currentName");
            UtilTimerStack.push((String)currentName);
        }

        @Override
        public void close() {
            if (this.stopped) {
                if (DevModeUtils.isEnabled()) {
                    throw new IllegalStateException("Stop should only be called once");
                }
                return;
            }
            UtilTimerStack.pop((String)this.currentName);
            this.stopped = true;
        }

        @Override
        public void mark(@Nonnull String newName) {
            Preconditions.checkNotNull((Object)newName, (Object)"newName");
            UtilTimerStack.pop((String)this.currentName);
            this.currentName = newName;
            UtilTimerStack.push((String)newName);
        }

        @Override
        public void stop() {
            this.close();
        }
    }
}

