/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PredicateUtils {
    private static final Predicate<String> NOT_BLANK = new Predicate<String>(){

        public boolean apply(String value) {
            return StringUtils.isNotBlank((String)value);
        }
    };

    private PredicateUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static <T> boolean addIf(@Nonnull Predicate<T> predicate, @Nonnull Collection<T> collection, @Nullable T value) {
        return predicate.apply(value) && collection.add(value);
    }

    public static <T> void addIf(@Nonnull Predicate<T> predicate, @Nonnull Collection<T> collection, @Nullable Iterable<T> values) {
        if (values != null) {
            Iterables.addAll(collection, (Iterable)Iterables.filter(values, predicate));
        }
    }

    public static Predicate<String> notBlank() {
        return NOT_BLANK;
    }

    public static Predicate<String> startsWith(final @Nonnull String prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
        return new Predicate<String>(){

            public boolean apply(String value) {
                return StringUtils.startsWith((String)value, (String)prefix);
            }
        };
    }
}

