/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.FilteredPageImpl;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class PageUtils {
    public static final int SUBPAGE_MULTIPLIER = 2;

    protected PageUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nullable
    public static <S, ST extends S> Page<S> asPageOf(@Nonnull Class<S> superType, @Nullable Page<ST> page) {
        Preconditions.checkNotNull(superType, (Object)"superType");
        return page;
    }

    public static <T> Page<T> createEmptyPage(PageRequest pageRequest) {
        return PageUtils.createPage(Collections.emptyList(), pageRequest);
    }

    public static <T> Page<T> createPage(Iterable<T> elements, PageRequest request) {
        int size = Iterables.size(elements);
        boolean lastPage = size <= request.getLimit();
        int pageSize = lastPage ? size : request.getLimit();
        return new PageImpl(request, pageSize, Iterables.limit(elements, (int)pageSize), lastPage);
    }

    public static <T> Page<T> createPage(Iterable<T> elements, boolean lastPage, PageRequest request) {
        int size = Iterables.size(elements);
        int pageSize = lastPage ? size : request.getLimit();
        return new PageImpl(request, pageSize, Iterables.limit(elements, (int)pageSize), lastPage);
    }

    public static <T> Page<T> createPage(PageRequest request, Function<Integer, T> elementGenerator) {
        int index;
        Object element;
        ArrayList<Object> values = new ArrayList<Object>();
        int num = request.getLimit() + 1;
        for (int i = 0; i < num && (element = elementGenerator.apply((Object)(index = request.getStart() + i))) != null; ++i) {
            values.add(element);
        }
        return PageUtils.createPage(values, request);
    }

    @Nonnull
    public static <T> Page<T> filterPages(PageProvider<T> provider, Predicate<? super T> predicate, PageRequest request) {
        Page<T> internalPage;
        int internalStart = request.getStart();
        int internalLimit = request.getLimit() * 2;
        int pageLimit = request.getLimit() + 1;
        TreeMap results = new TreeMap();
        block0: do {
            PageRequestImpl internalRequest = new PageRequestImpl(internalStart, internalLimit);
            internalPage = provider.get((PageRequest)internalRequest);
            for (Map.Entry entry : internalPage.getOrdinalIndexedValues().entrySet()) {
                if (!predicate.apply(entry.getValue())) continue;
                results.put(entry.getKey(), entry.getValue());
                if (results.size() != pageLimit) continue;
                break block0;
            }
            internalStart += internalLimit;
        } while (results.size() < pageLimit && !internalPage.getIsLastPage());
        int size = results.size();
        boolean lastPage = size < pageLimit;
        int pageSize = lastPage ? size : request.getLimit();
        return new FilteredPageImpl(request, pageSize, results, lastPage);
    }

    @Nonnull
    public static PageRequest newRequest(int start, int limit) {
        return new PageRequestImpl(start, limit);
    }

    @Nonnull
    public static <T> Page<T> reducePage(Page<T> page, int limit, PageRequest request) {
        Preconditions.checkArgument((request.getLimit() >= limit ? 1 : 0) != 0);
        return new PageImpl(request.buildRestrictedPageRequest(limit), Iterables.limit((Iterable)page.getValues(), (int)limit), page.getSize() <= limit);
    }
}

