/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtils {
    private static final List<String> BYTE_MAGNITUDES = ImmutableList.of((Object)"B", (Object)"kB", (Object)"MB", (Object)"GB");
    private static final Logger log = LoggerFactory.getLogger(NumberUtils.class);

    private NumberUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static Integer parse(String s, @Nullable Integer defaultValue, String message) {
        if (StringUtils.isNotEmpty((String)s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.error(message);
            }
        }
        return defaultValue;
    }

    public static Integer parse(String s, String message) {
        return NumberUtils.parse(s, null, message);
    }

    public static String formatSize(double size) {
        Iterator<String> it = BYTE_MAGNITUDES.iterator();
        String unit = it.next();
        while (size > 1024.0 && it.hasNext()) {
            size /= 1024.0;
            unit = it.next();
        }
        return String.format("%.2f %s", size, unit);
    }

    public static Long toLong(String s, Long defaultValue) {
        if (StringUtils.isNotEmpty((String)s)) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

