/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util.concurrent;

import com.atlassian.stash.util.Operation;
import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class MappedReentrantLock<K> {
    private final boolean fair;
    private final Map<K, WeakReference<ReentrantLock>> locks;
    private final ConcurrentOperationMap<K, ReentrantLock> operationMap;

    public MappedReentrantLock() {
        this(false);
    }

    public MappedReentrantLock(boolean fair) {
        this.fair = fair;
        this.locks = Maps.newConcurrentMap();
        this.operationMap = new ConcurrentOperationMapImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T withLock(@Nonnull K key, @Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(operation, (Object)"operation");
        ReentrantLock lock = this.getLock(key);
        lock.lock();
        try {
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    private ReentrantLock getLock(K key) {
        try {
            return (ReentrantLock)this.operationMap.runOperation(key, (Callable)new GetLockCallable(key));
        }
        catch (ExecutionException e) {
            throw new RejectedExecutionException("A lock could not be created for " + key, Throwables.getRootCause((Throwable)e));
        }
    }

    private class GetLockCallable
    implements Callable<ReentrantLock> {
        private final K key;

        private GetLockCallable(K key) {
            this.key = key;
        }

        @Override
        public ReentrantLock call() throws Exception {
            ReentrantLock lock;
            WeakReference reference = (WeakReference)MappedReentrantLock.this.locks.get(this.key);
            ReentrantLock reentrantLock = lock = reference == null ? null : (ReentrantLock)reference.get();
            if (lock == null) {
                lock = new ReentrantLock(MappedReentrantLock.this.fair);
                MappedReentrantLock.this.locks.put(this.key, new WeakReference<ReentrantLock>(lock));
            }
            return lock;
        }
    }
}

