/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.fugue.Option;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class UserUtils {
    public static final Predicate<StashUser> IS_ACTIVE = new Predicate<StashUser>(){

        public boolean apply(StashUser user) {
            return user.isActive();
        }
    };
    public static final Function<StashUser, Integer> TO_ID = new Function<StashUser, Integer>(){

        public Integer apply(StashUser user) {
            return user.getId();
        }
    };
    public static final Function<Principal, String> TO_USERNAME = new Function<Principal, String>(){

        public String apply(Principal user) {
            return user.getName();
        }
    };
    private static final String NAME_MATCHING_REGEX = "(\\b|^|[^\\p{L}\\p{N}])";
    private static final Function<StashUser, String> TO_DISPLAY_NAME = new Function<StashUser, String>(){

        public String apply(StashUser user) {
            return user.getDisplayName();
        }
    };

    private UserUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static Option<String> getCurrentUserName(@Nonnull StashAuthenticationContext authentication) {
        return Option.option((Object)authentication.getCurrentUser()).map(TO_DISPLAY_NAME);
    }

    @Nonnull
    public static Pattern createNameMatchingPattern(@Nonnull String filter) {
        Preconditions.checkNotNull((Object)filter, (Object)"filter");
        return Pattern.compile(NAME_MATCHING_REGEX + Pattern.quote(filter), 2);
    }
}

