/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.DevModeUtils;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Timer;
import com.atlassian.util.profiling.UtilTimerStack;

public class TimerUtils {
    private TimerUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static boolean isActive() {
        return UtilTimerStack.isActive();
    }

    public static Timer start(final String name) {
        UtilTimerStack.push((String)name);
        return new Timer(){
            private boolean stopped = false;

            @Override
            public void stop() {
                if (this.stopped) {
                    if (DevModeUtils.isEnabled()) {
                        throw new IllegalStateException("Stop should only be called once");
                    }
                    return;
                }
                UtilTimerStack.pop((String)name);
                this.stopped = true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T time(String name, Operation<T, E> supplier) throws E {
        UtilTimerStack.push((String)name);
        try {
            Object object = supplier.perform();
            return (T)object;
        }
        finally {
            UtilTimerStack.pop((String)name);
        }
    }
}

