/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternIterable<T>
implements Iterable<T> {
    private final Matcher matcher;
    private final Function<MatchResult, T> extractor;

    public PatternIterable(Pattern pattern, String text, Function<MatchResult, T> extractor) {
        this(pattern.matcher(text), extractor);
    }

    public PatternIterable(Matcher matcher, Function<MatchResult, T> extractor) {
        this.matcher = matcher;
        this.extractor = extractor;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return PatternIterable.this.matcher.find();
            }

            @Override
            public T next() {
                return PatternIterable.this.extractor.apply((Object)PatternIterable.this.matcher.toMatchResult());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Function<MatchResult, String> group(final int n) {
        return new Function<MatchResult, String>(){

            public String apply(MatchResult matchResult) {
                return matchResult.group(n);
            }
        };
    }
}

